﻿(function ($) {
    $.widget("a4.a4dynamicGrid", {
        options: {
            maxRows: undefined,
            autoGeneratePositions: true,
            inputsPrefix: undefined,
            selectors: {
                contentTable: ".v-contentTable",
                templateTable: ".v-templateTable",
                actionsContainer: ".v-actions",
                rowIndex: ".v-itemIndex",
                actions: {
                    addRow: ".h-addRow",
                    deleteRow: ".h-deleteRow",
                    moveRowUp: ".h-moveUp",
                    moveRowDown: ".h-moveDown"
                }
            }
        },
        _create: function () {
            var self = this;
            this.contentTable = $(this.options.selectors.contentTable, this.element);
            this.templateTable = $(this.options.selectors.templateTable, this.element);
            this.actionsContainer = $(this.options.selectors.actionsContainer, this.element);

            if ($("tbody tr", this.contentTable).length > 0) {
                if (this.options.autoGeneratePositions) {
                    this._recalculateItemIndexes(true);
                }

                $("tbody tr", this.contentTable).each(function (index) {
                    self._trigger("rowReady", null, { item: $(this) });
                });
            }
            else {
                this.contentTable.hide();
            }

            this._bindEvents();

            this._trigger("ready", null, {});
        },
        _bindEvents: function () {
            var self = this;
            var editor = this.element;
            var tableBody = $("tbody", this.contentTable);

            this._on({
                "click .h-moveUp": function (event) {
                    var element = $(event.currentTarget);
                    var item = element.closest("tr");
                    var prevItem = item.prev(":not(.deleted)");

                    if (prevItem.length > 0) {
                        item.after(prevItem);
                        self._swapItemIndexes(item, prevItem);

                        this._trigger("moveUp", null, { item: item });
                    }
                },
                "click .h-moveDown": function (event) {
                    var element = $(event.currentTarget);
                    var item = element.closest("tr");
                    var nextItem = item.next(":not(.deleted)");

                    if (nextItem.length > 0) {
                        nextItem.after(item);
                        self._swapItemIndexes(item, nextItem);

                        this._trigger("moveDown", null, { item: item });
                    }
                },
                "click .h-deleteRow": function (event) {
                    var element = $(event.currentTarget);
                    var item = element.closest("tr");
                    item.addClass("deleted");

                    self._recalculateItemIndexes();

                    if ($("tr:not(.deleted)", tableBody).length == 0) {
                        self.contentTable.hide();
                    }

                    if (!self.options.maxRows || $("tr:visible", tableBody).length < self.options.maxRows) {
                        $(".h-addRow", self.actionsContainer).show();
                    }

                    this._trigger("deleteRow", null, { item: item });
                },
                "click .h-addRow": function (event) {
                    var element = $(event.currentTarget);
                    var rowIndex = $("tr", tableBody).length;
                    var rowPosition = $("tr:visible", tableBody).length + 1;

                    self.contentTable.show();

                    var newItem = $("tr", self.templateTable).clone();
                    newItem.find(self.options.selectors.rowIndex).html(rowPosition);
                    //newItem.find(".v-rowPosition").val(rowPosition);
                    newItem.removeClass("row0");
                    newItem.addClass("row" + (rowIndex + 1));

                    var editorControlName = $(".editorControlName", editor).attr("id");
                    
                    $("input, select", newItem).each(function () {
                        $(this).attr("id", editorControlName + "[" + rowIndex + "]." + $(this).attr("id"));
                        $(this).attr("name", editorControlName + "[" + rowIndex + "]." + $(this).attr("name"));
                    });

                    newItem.appendTo(tableBody);

                    if (self.options.maxRows && rowPosition >= self.options.maxRows) {
                        element.hide();
                    }

                    this._trigger("rowReady", null, { item: newItem });
                    this._trigger("addRow", null, { item: newItem, index: rowIndex });
                },
                "keypress input": function (event) {
                    return (event.keyCode != 13);
                }
            });
        },
        _recalculateItemIndexes: function () {
            var self = this;

            return $("tbody tr:visible", this.contentTable).each(function (index) {
                $(self.options.selectors.rowIndex, $(this)).html(index + 1);
            });
        },
        _swapItemIndexes: function (item1, item2) {
            var item1Position = $(this.options.selectors.rowIndex, item1).html();
            var item2Position = $(this.options.selectors.rowIndex, item2).html();

            $(".v-rowPosition", item1).val(item2Position);
            $(this.options.selectors.rowIndex, item1).html(item2Position);

            $(".v-rowPosition", item2).val(item1Position);
            $(this.options.selectors.rowIndex, item2).html(item1Position);

            this._trigger("swapRow", null, { item1: item1, item2: item2 });
        },
        getValue: function () {
            return $("tbody tr:not(.deleted)", this.contentTable).map(function () {
                var rowData = {};

                $(":input", $(this)).each(function () {
                    var inputName = $(this).attr("Name");

                    inputName = inputName.substring(inputName.lastIndexOf(".") + 1);

                    rowData[inputName] = $(this).val();
                });

                return rowData;
            }).toArray();
        },
        clearValue: function () {
            $("tbody tr", this.contentTable).remove();

            this.contentTable.hide();

            $(".v-addRow", this.actionsContainer).show();
        },
        setValue: function (data) {
            var grid = this;
            var tableBody = $("tbody", grid.contentTable);
            var editor = this.element;
            
            data.forEach(
                function (value) {
                    
                    var rowIndex = $("tr", tableBody).length;
                    var rowPosition = $("tr:visible", tableBody).length + 1;

                    grid.contentTable.show();

                    var newItem = $("tr", grid.templateTable).clone();
                    newItem.find(grid.options.selectors.rowIndex).html(rowPosition);
                    newItem.removeClass("row0");
                    newItem.addClass("row" + (rowIndex + 1));

                    var editorControlName = $(".editorControlName", editor).attr("id");
                                        
                    $("input, select", newItem).each(function () {
                        $(this).attr("id", editorControlName + "[" + rowIndex + "]" + $(this).attr("id"));
                        $(this).attr("name", editorControlName + "[" + rowIndex + "]." + $(this).attr("name"));

                        var inputName = $(this).attr("name");
                        inputName = inputName.substring(inputName.lastIndexOf(".") + 1);
                        $(this).val(value[inputName]);
                    });

                    newItem.appendTo(tableBody);

                    grid._trigger("rowReady", null, { item: newItem });
                    grid._trigger("addRow", null, { item: newItem, index: rowIndex });
                }
            );
          
        }
    });
}(jQuery));